#!/bin/sh

if [ ! "$MINIBROWSER" ]; then
. auth.cgi
fi

HTML_PAGE="../setup_date.html"

if [ ! "$MINIBROWSER" ]; then
    echo "Content-type: text/html"
    echo
fi

if [ -r /etc/default/ntpdate ]; then
	. /etc/default/ntpdate
fi

if [ "$NTPDATE" = yes ]; then
    NTP_OPTION="<OPTION>yes<\/OPTION><OPTION>no<\/OPTION>"
else
    NTP_OPTION="<OPTION>no<\/OPTION><OPTION>yes<\/OPTION>"
fi

DAY="`date +%d`"
MON="`date +%m`"
YEAR="`date +%Y`"
HOUR="`date +%H`"
MIN="`date +%M`"
SEC="`date +%S`"

if [ "$MINIBROWSER" ]; then
    echo "NTPDATE=$NTPDATE"
    echo "DAY=$DAY"
    echo "MON=$MON"
    echo "YEAR=$YEAR"
    echo "HOUR=$HOUR"
    echo "MIN=$MIN"
    echo "SEC=$SEC"
else
    LOGOUT_REF=""

    if [ "$PASSWORD_MB" ]; then
	LOGOUT_REF="                        \<A href=\"setup_logout.cgi\" title=\"Logout\"\>Logout\<\/A\>"
    fi

    cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g | sed /"setup_logout.cgi"/s/"^.*$"/"$LOGOUT_REF"/ | sed s/'$NTP_OPTION'/"$NTP_OPTION"/g \
        	   | sed s/'$DAY'/"$DAY"/g | sed s/'$MON'/"$MON"/g | sed s/'$YEAR'/"$YEAR"/g \
        	   | sed s/'$HOUR'/"$HOUR"/g | sed s/'$MIN'/"$MIN"/g | sed s/'$SEC'/"$SEC"/g
fi
