#!/bin/sh

#echo "Content-type: text/html"
#echo

PLCSYNC_CONFIG="/etc/default/plcsync"
PLCCOMS_CONFIG="/etc/default/plccoms"
MBROWSER_CONFIG="/etc/default/minibrowser"

DATA="`cat | sed s/'\&'/' '/g`"

#echo $DATA

PLCSYNCLOG="`echo $DATA | sed s/' '/'\n'/g | grep PLCSYNCLOG | sed s/'^.*='/''/`"
PLCCOMSLOG="`echo $DATA | sed s/' '/'\n'/g | grep PLCCOMSLOG | sed s/'^.*='/''/`"
MBROWSERLOG="`echo $DATA | sed s/' '/'\n'/g | grep MBROWSERLOG | sed s/'^.*='/''/`"
REBOOT="`echo $DATA | sed s/' '/'\n'/g | grep REBOOT | sed s/'^.*='/''/`"
CLEARCACHE="`echo $DATA | sed s/' '/'\n'/g | grep CLEARCACHE | sed s/'^.*='/''/`"

if [ -r $PLCSYNC_CONFIG ]; then
	. $PLCSYNC_CONFIG
fi

TMP_CONFIG=`cat $PLCSYNC_CONFIG`

if [ "$PLCSYNCLOG" = "checked" ]; then
    echo "<P>CHECKED</P>"
    if [ "$DEBUG" != yes ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=yes'/`

	echo "$TMP_CONFIG" > $PLCSYNC_CONFIG
    fi
else
    echo "<P>NOT CHECKED</P>"
    if [ "$DEBUG" != no ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=no'/`

	echo "$TMP_CONFIG" > $PLCSYNC_CONFIG

	rm $LOG_FILE
    fi
fi

if [ -r $PLCCOMS_CONFIG ]; then
	. $PLCCOMS_CONFIG
fi

TMP_CONFIG=`cat $PLCCOMS_CONFIG`

if [ "$PLCCOMSLOG" = "checked" ]; then
    echo "<P>CHECKED</P>"
    if [ "$DEBUG" != yes ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=yes'/`

	echo "$TMP_CONFIG" > $PLCCOMS_CONFIG

	killall PLCComS
    fi
else
    echo "<P>NOT CHECKED</P>"
    if [ "$DEBUG" != no ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=no'/`

	echo "$TMP_CONFIG" > $PLCCOMS_CONFIG

	killall PLCComS
    fi
fi

if [ -r $MBROWSER_CONFIG ]; then
	. $MBROWSER_CONFIG
fi

TMP_CONFIG=`cat $MBROWSER_CONFIG`

if [ "$MBROWSERLOG" = "checked" ]; then
    echo "<P>CHECKED</P>"
    if [ "$DEBUG" != yes ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=yes'/`

	echo "$TMP_CONFIG" > $MBROWSER_CONFIG

	killall MiniBrowser
    fi
else
    echo "<P>NOT CHECKED</P>"
    if [ "$DEBUG" != no ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=no'/`

	echo "$TMP_CONFIG" > $MBROWSER_CONFIG

	killall MiniBrowser
    fi
fi

if [ "$CLEARCACHE" = "checked" ]; then
    if [ -d "$CACHE_DIR" ]; then
	rm -rf $CACHE_DIR/*
    fi
fi

if [ "$REBOOT" = "checked" ]; then
    reboot -d 2 &
fi

sh setup_debug.cgi
