#!/bin/sh

#echo "Content-type: text/html"
#echo

XSERVER_CONFIG="/etc/default/xserver"
DISPLAY_CONFIG="/etc/default/display"
LOGO_CONFIG="/tmp/.logo.cfg"

if [ -r /etc/default/xserver ]; then
	. /etc/default/xserver
fi

if [ "$DISPLAY" = "" ]; then
    export DISPLAY=:0
fi

#echo "`env`"

DATA="`cat | sed s/'\&'/' '/g`"

#echo $DATA

CALIBRATE="`echo $DATA | sed s/' '/'\n'/g | grep CALIBRATE | sed s/'^.*='/''/`"
SCRSAVER="`echo $DATA | sed s/' '/'\n'/g | grep SCRSAVER | sed s/'^.*='/''/`"
BRIGHTNESS="`echo $DATA | sed s/' '/'\n'/g | grep BRIGHTNESS | sed s/'^.*='/''/`"
ROTATION="`echo $DATA | sed s/' '/'\n'/g | grep ROTATION | sed s/'^.*='/''/`"
CURSOR="`echo $DATA | sed s/' '/'\n'/g | grep CURSOR | sed s/'^.*='/''/`"

if [ "$XSERVER_ROTATION" = "" ]; then
    XSERVER_ROTATION="0"
fi

if [ "$ROTATION" = "" ]; then
    ROTATION="$XSERVER_ROTATION"
fi

ROTATION_OLD="$XSERVER_ROTATION"

if [ "$CALIBRATE" = "yes" ]; then
    tscal >/dev/null 2>&1 &
fi

expr $SCRSAVER \+ 1 >/dev/null 2>&1

if [ $? != 0 ]; then
    TIMEOUT_MIN="$XSERVER_TIMEOUT"
else
    TIMEOUT_MIN="$SCRSAVER"
fi

#if [ $(($TIMEOUT_MIN < 1)) == 1 ]; then
#    TIMEOUT_MIN="1"
#fi

#if [ $(($TIMEOUT_MIN > 255)) == 1 ]; then
#    TIMEOUT_MIN="255"
#fi

#TIMEOUT="`expr $TIMEOUT_MIN \* 60`"

#echo "CALIBRATE  = $CALIBRATE"
#echo "SCRSAVER   = $SCRSAVER"
#echo "BRIGHTNESS = $BRIGHTNESS"
#echo "ROTATION   = $ROTATION"
#echo "TIMEOUT    = $TIMEOUT"
#echo "CURSOR     = $CURSOR"

if [ "$XSERVER_CURSOR" = "" ]; then
    XSERVER_CURSOR="X_cursor"
fi

case "$CURSOR" in
    hand)
	CURSOR="hand2"
	;;
    none)
	CURSOR="shuttle"
	;;
    "")
	CURSOR="$XSERVER_CURSOR"
	;;
esac

#echo "xset s $TIMEOUT"

#xset s $TIMEOUT

#echo xsetroot -cursor_name $CURSOR

xsetroot -cursor_name $CURSOR

if [ "`cat $XSERVER_CONFIG | grep XSERVER_ROTATION=`" = "" ]; then
    echo "" >> $XSERVER_CONFIG
    echo "# Screen rotation (0, 90, 180, 270)" >> $XSERVER_CONFIG
    echo "XSERVER_ROTATION=0" >> $XSERVER_CONFIG
fi

TMP_CONFIG=`cat $XSERVER_CONFIG`
TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^XSERVER_TIMEOUT=.*'/"XSERVER_TIMEOUT=$TIMEOUT_MIN"/`
TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^XSERVER_CURSOR=.*'/"XSERVER_CURSOR=$CURSOR"/`
TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^XSERVER_ROTATION=.*'/"XSERVER_ROTATION=$ROTATION"/`

echo "$TMP_CONFIG" > $XSERVER_CONFIG

echo "logo_rotation=$ROTATION" > $LOGO_CONFIG

flash_eraseall /dev/mtd8 >/dev/null 2>&1
nandwrite -p /dev/mtd8 $LOGO_CONFIG >/dev/null 2>&1

killall -9 bkld >/dev/null 2>&1

case "$BRIGHTNESS" in
    high)
	BRIGHTNESS_NUM="100"
	;;
    middle)
	BRIGHTNESS_NUM="50"
	;;
    low)
	BRIGHTNESS_NUM="10"
	;;
esac

/sbin/backlight $BRIGHTNESS_NUM

TMP_CONFIG=`cat $DISPLAY_CONFIG`
TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DISPLAY_BRIGHTNESS=.*'/"DISPLAY_BRIGHTNESS=$BRIGHTNESS"/`

echo "$TMP_CONFIG" > $DISPLAY_CONFIG

if [ "$ROTATION" != "$ROTATION_OLD" ]; then
    killall Xfbdev
    sleep 3
fi

sleep 2

sh setup_display.cgi
