#!/bin/sh

if [ ! "$MINIBROWSER" ]; then
. auth.cgi
fi

HTML_PAGE="../setup_debug.html"

if [ ! "$MINIBROWSER" ]; then
    echo "Content-type: text/html"
    echo
fi

if [ -r /etc/default/plccoms ]; then
	. /etc/default/plccoms
fi

if [ "$DEBUG" = yes ]; then
    PLCCOMSLOG_OPTION="checked"
fi

if [ -r /etc/default/minibrowser ]; then
	. /etc/default/minibrowser
fi

if [ "$DEBUG" = yes ]; then
    MBROWSERLOG_OPTION="checked"
fi

CACHEINFO="`du -h -s $CACHE_DIR/ | awk '{print $1}'`"

if [ "$CACHEINFO" = "0" ]; then
    CACHEINFO="0K"
fi

CACHEINFO_PERC="`df 2>/dev/null | awk '/\/dev\/mtdblock5/{print $5}'`"

CACHEINFO="${CACHEINFO}B $CACHEINFO_PERC"

if [ "$MINIBROWSER" ]; then
    echo "PLCCOMSLOG_OPTION=$PLCCOMSLOG_OPTION"
    echo "MBROWSERLOG_OPTION=$MBROWSERLOG_OPTION"
    echo "CACHESIZE=${CACHEINFO%% *}"
    echo "CACHESIZE_PERC=$CACHEINFO_PERC"
else
    LOGOUT_REF=""

    if [ "$PASSWORD_MB" ]; then
	LOGOUT_REF="                        \<A href=\"setup_logout.cgi\" title=\"Logout\"\>Logout\<\/A\>"
    fi

    cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g | sed /"setup_logout.cgi"/s/"^.*$"/"$LOGOUT_REF"/ | sed s/'$PLCCOMSLOG_OPTION'/"$PLCCOMSLOG_OPTION"/g \
        	   | sed s/'$MBROWSERLOG_OPTION'/"$MBROWSERLOG_OPTION"/g \
        	   | sed s/'$CACHEINFO'/"$CACHEINFO"/g
fi
